<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('course_reviews', function (Blueprint $table) {
            $table->unsignedBigInteger('Review_id')->autoIncrement();
            $table->unsignedBigInteger('User_id');
            $table->unsignedBigInteger('Course_id');
            $table->integer('Rating');
            $table->text('Comment')->nullable();
            $table->timestamp('Created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('Updated_at')->default(DB::raw('CURRENT_TIMESTAMP'))->onUpdate(DB::raw('CURRENT_TIMESTAMP'));
            $table->unique(['User_id', 'Course_id'], 'unique_user_course_review');
            $table->foreign('User_id', 'course_reviews_user_id_foreign')->references('User_id')->on('users')->onDelete('cascade');
            $table->foreign('Course_id', 'course_reviews_course_id_foreign')->references('Course_id')->on('courses')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('course_reviews');
    }
};
